/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.uniform;

import net.optifine.entity.model.anim.ExpressionType;
import net.optifine.entity.model.anim.IExpression;
import net.optifine.entity.model.anim.IExpressionBool;
import net.optifine.entity.model.anim.IExpressionFloat;
import shadersmod.uniform.ShaderUniformBase;
import shadersmod.uniform.ShaderUniformFloat;
import shadersmod.uniform.ShaderUniformInt;

public enum UniformType {
    BOOL,
    INT,
    FLOAT;


    public ShaderUniformBase makeShaderUniform(String name) {
        switch (this) {
            case BOOL: {
                return new ShaderUniformInt(name);
            }
            case INT: {
                return new ShaderUniformInt(name);
            }
            case FLOAT: {
                return new ShaderUniformFloat(name);
            }
        }
        throw new RuntimeException("Unknown uniform type: " + (Object)((Object)this));
    }

    public void updateUniform(IExpression expression, ShaderUniformBase uniform) {
        switch (this) {
            case BOOL: {
                this.updateUniformBool((IExpressionBool)expression, (ShaderUniformInt)uniform);
                return;
            }
            case INT: {
                this.updateUniformInt((IExpressionFloat)expression, (ShaderUniformInt)uniform);
                return;
            }
            case FLOAT: {
                this.updateUniformFloat((IExpressionFloat)expression, (ShaderUniformFloat)uniform);
                return;
            }
        }
        throw new RuntimeException("Unknown uniform type: " + (Object)((Object)this));
    }

    private void updateUniformBool(IExpressionBool expression, ShaderUniformInt uniform) {
        boolean flag = expression.eval();
        int i = flag ? 1 : 0;
        uniform.setValue(i);
    }

    private void updateUniformInt(IExpressionFloat expression, ShaderUniformInt uniform) {
        int i = (int)expression.eval();
        uniform.setValue(i);
    }

    private void updateUniformFloat(IExpressionFloat expression, ShaderUniformFloat uniform) {
        float f = expression.eval();
        uniform.setValue(f);
    }

    public boolean matchesExpressionType(ExpressionType expressionType) {
        switch (this) {
            case BOOL: {
                return expressionType == ExpressionType.BOOL;
            }
            case INT: {
                return expressionType == ExpressionType.FLOAT;
            }
            case FLOAT: {
                return expressionType == ExpressionType.FLOAT;
            }
        }
        throw new RuntimeException("Unknown uniform type: " + (Object)((Object)this));
    }

    public static UniformType parse(String type) {
        UniformType[] auniformtype = UniformType.values();
        int i = 0;
        while (i < auniformtype.length) {
            UniformType uniformtype = auniformtype[i];
            if (uniformtype.name().toLowerCase().equals(type)) {
                return uniformtype;
            }
            ++i;
        }
        return null;
    }
}

