/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.uniform;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.biome.BiomeGenBase;
import net.optifine.entity.model.anim.ConstantFloat;
import net.optifine.entity.model.anim.IExpression;
import net.optifine.entity.model.anim.IExpressionResolver;
import shadersmod.common.SMCLog;
import shadersmod.uniform.ShaderParameterBool;
import shadersmod.uniform.ShaderParameterFloat;

public class ShaderExpressionResolver
implements IExpressionResolver {
    private Map<String, IExpression> mapExpressions = new HashMap<String, IExpression>();

    public ShaderExpressionResolver(Map<String, IExpression> map) {
        this.registerExpressions();
        for (String s : map.keySet()) {
            IExpression iexpression = map.get(s);
            this.registerExpression(s, iexpression);
        }
    }

    private void registerExpressions() {
        ShaderParameterFloat[] ashaderparameterfloat = ShaderParameterFloat.values();
        int i = 0;
        while (i < ashaderparameterfloat.length) {
            ShaderParameterFloat shaderparameterfloat = ashaderparameterfloat[i];
            this.mapExpressions.put(shaderparameterfloat.getName(), shaderparameterfloat);
            ++i;
        }
        ShaderParameterBool[] ashaderparameterbool = ShaderParameterBool.values();
        int k = 0;
        while (k < ashaderparameterbool.length) {
            ShaderParameterBool shaderparameterbool = ashaderparameterbool[k];
            this.mapExpressions.put(shaderparameterbool.getName(), shaderparameterbool);
            ++k;
        }
        BiomeGenBase[] abiomegenbase = BiomeGenBase.getBiomeGenArray();
        int l = 0;
        while (l < abiomegenbase.length) {
            BiomeGenBase biomegenbase = abiomegenbase[l];
            if (biomegenbase != null) {
                String s = biomegenbase.biomeName.trim();
                s = "BIOME_" + s.toUpperCase().replace(' ', '_');
                int j = biomegenbase.biomeID;
                ConstantFloat iexpression = new ConstantFloat(j);
                this.registerExpression(s, iexpression);
            }
            ++l;
        }
    }

    public boolean registerExpression(String name, IExpression expr) {
        if (this.mapExpressions.containsKey(name)) {
            SMCLog.warning("Expression already defined: " + name);
            return false;
        }
        this.mapExpressions.put(name, expr);
        return true;
    }

    @Override
    public IExpression getExpression(String name) {
        return this.mapExpressions.get(name);
    }

    public boolean hasExpression(String name) {
        return this.mapExpressions.containsKey(name);
    }
}

