/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import net.minecraft.src.Config;
import shadersmod.client.Shaders;
import shadersmod.common.SMCLog;

public class ShadersBuiltIn {
    public static Reader getShaderReader(String filename) {
        return filename.endsWith("/deferred_last.vsh") ? ShadersBuiltIn.getCompositeShaderReader(true, true) : (filename.endsWith("/composite_last.vsh") ? ShadersBuiltIn.getCompositeShaderReader(false, true) : (filename.endsWith("/deferred_last.fsh") ? ShadersBuiltIn.getCompositeShaderReader(true, false) : (filename.endsWith("/composite_last.fsh") ? ShadersBuiltIn.getCompositeShaderReader(false, false) : null)));
    }

    private static Reader getCompositeShaderReader(boolean deferred, boolean vertex) {
        if (!ShadersBuiltIn.hasDeferredPrograms() && !ShadersBuiltIn.hasSkipClear()) {
            return null;
        }
        int[] aint = ShadersBuiltIn.getLastFlipBuffers(deferred);
        if (aint == null) {
            return null;
        }
        if (!vertex) {
            String s = deferred ? "deferred" : "composite";
            SMCLog.info("flipped buffers after " + s + ": " + Config.arrayToString(aint));
        }
        String s1 = vertex ? ShadersBuiltIn.getCompositeVertexShader(aint) : ShadersBuiltIn.getCompositeFragmentShader(aint);
        return new StringReader(s1);
    }

    private static Reader getCompositeFragmentShaderReader(boolean deferred) {
        if (!ShadersBuiltIn.hasDeferredPrograms() && !ShadersBuiltIn.hasSkipClear()) {
            return null;
        }
        int[] aint = ShadersBuiltIn.getLastFlipBuffers(deferred);
        if (aint == null) {
            return null;
        }
        String s = ShadersBuiltIn.getCompositeFragmentShader(aint);
        return new StringReader(s);
    }

    private static boolean hasDeferredPrograms() {
        int i = 33;
        while (i < 41) {
            if (Shaders.programsID[i] != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasSkipClear() {
        int i = 0;
        while (i < Shaders.gbuffersClear.length) {
            if (!Shaders.gbuffersClear[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String getCompositeVertexShader(int[] buffers) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#version 120                        ");
        list.add("varying vec2 texcoord;              ");
        list.add("void main()                         ");
        list.add("{                                   ");
        list.add("  gl_Position = ftransform();       ");
        list.add("  texcoord = gl_MultiTexCoord0.xy;  ");
        list.add("}                                   ");
        return Config.listToString(list, "\n");
    }

    private static String getCompositeFragmentShader(int[] buffers) {
        ArrayList<String> list = new ArrayList<String>();
        String s = Config.arrayToString(buffers, "");
        list.add("#version 120                                           ");
        int i = 0;
        while (i < buffers.length) {
            list.add("uniform sampler2D colortex" + buffers[i] + ";        ");
            ++i;
        }
        list.add("varying vec2 texcoord;                                 ");
        list.add("/* DRAWBUFFERS:" + s + " */                  ");
        list.add("void main()                                            ");
        list.add("{                                                      ");
        int j = 0;
        while (j < buffers.length) {
            list.add("  gl_FragData[" + j + "] = texture2D(colortex" + buffers[j] + ", texcoord);     ");
            ++j;
        }
        list.add("}                                                      ");
        return Config.listToString(list, "\n");
    }

    private static int[] getLastFlipBuffers(boolean deferred) {
        return deferred ? ShadersBuiltIn.getLastFlipBuffers(33, 8) : ShadersBuiltIn.getLastFlipBuffers(21, 8);
    }

    private static int[] getLastFlipBuffers(int programStart, int programCount) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        boolean[] aboolean = new boolean[8];
        int i = programStart;
        while (i < programStart + programCount) {
            if (Shaders.programsID[i] != 0) {
                boolean[] aboolean1 = ShadersBuiltIn.getProgramTogglesTexture(i);
                int j = 0;
                while (j < aboolean1.length) {
                    boolean flag = aboolean1[j];
                    if (flag) {
                        aboolean[j] = !aboolean[j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        int k = 0;
        while (k < aboolean.length) {
            boolean flag1 = aboolean[k];
            if (flag1) {
                list.add(new Integer(k));
            }
            ++k;
        }
        if (list.isEmpty()) {
            return null;
        }
        Integer[] ainteger = list.toArray(new Integer[list.size()]);
        return Config.toPrimitive(ainteger);
    }

    private static boolean[] getProgramTogglesTexture(int program) {
        boolean[] aboolean = new boolean[8];
        String s = Shaders.programsDrawBufSettings[program];
        if (s == null) {
            return aboolean;
        }
        int i = 0;
        while (i < s.length()) {
            char c0 = s.charAt(i);
            int j = c0 - 48;
            if (j >= 0 && j < aboolean.length) {
                aboolean[j] = true;
            }
            ++i;
        }
        return aboolean;
    }
}

