/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.src.CapeImageBuffer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class CapeUtils {
    public static void downloadCape(AbstractClientPlayer p_downloadCape_0_) {
        String s = p_downloadCape_0_.getNameClear();
        if (s != null && !s.isEmpty() && !s.contains("\u0000")) {
            String capeUrlFromSite = "https://velunia-mc.fr/api/skin-api/capes/" + s + ".png";
            boolean hasSiteCape = capeUrlFromSite != null && !capeUrlFromSite.isEmpty();
            String capeUrl = hasSiteCape ? capeUrlFromSite : "http://s.optifine.net/capes/" + s + ".png";
            String s2 = FilenameUtils.getBaseName((String)capeUrl);
            ResourceLocation resourcelocation = new ResourceLocation("capeof/" + s2);
            TextureManager texturemanager = Minecraft.getMinecraft().getTextureManager();
            ITextureObject itextureobject = texturemanager.getTexture(resourcelocation);
            if (itextureobject != null && itextureobject instanceof ThreadDownloadImageData) {
                ThreadDownloadImageData td = (ThreadDownloadImageData)itextureobject;
                if (td.imageFound != null && td.imageFound.booleanValue()) {
                    p_downloadCape_0_.setLocationOfCape(resourcelocation);
                }
                return;
            }
            CapeImageBuffer capeimagebuffer = new CapeImageBuffer(p_downloadCape_0_, resourcelocation);
            ThreadDownloadImageData td2 = new ThreadDownloadImageData(null, capeUrl, null, capeimagebuffer);
            td2.pipeline = true;
            texturemanager.loadTexture(resourcelocation, td2);
        }
    }

    public static BufferedImage parseCape(BufferedImage p_parseCape_0_) {
        int i = 64;
        int j = 32;
        int k = p_parseCape_0_.getWidth();
        int l = p_parseCape_0_.getHeight();
        while (i < k || j < l) {
            i *= 2;
            j *= 2;
        }
        BufferedImage bufferedimage = new BufferedImage(i, j, 2);
        Graphics graphics = bufferedimage.getGraphics();
        graphics.drawImage(p_parseCape_0_, 0, 0, null);
        graphics.dispose();
        return bufferedimage;
    }
}

