/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.util;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public final class RenderUtils {
    private RenderUtils() {
    }

    public static void drawRoundedRect(float x, float y, float w, float h, float r, int color) {
        if (w <= 0.0f || h <= 0.0f) {
            return;
        }
        r = Math.max(0.0f, Math.min(r, Math.min(w, h) * 0.5f));
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float rC = (float)(color >> 16 & 0xFF) / 255.0f;
        float gC = (float)(color >> 8 & 0xFF) / 255.0f;
        float bC = (float)(color & 0xFF) / 255.0f;
        GlStateManager.enableBlend();
        GlStateManager.disableTexture2D();
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GlStateManager.color(rC, gC, bC, a);
        RenderUtils.rect(x + r, y, x + w - r, y + h);
        RenderUtils.rect(x, y + r, x + r, y + h - r);
        RenderUtils.rect(x + w - r, y + r, x + w, y + h - r);
        int segments = Math.max(8, (int)(r * 0.75f));
        RenderUtils.quarterCircle(x + r, y + r, r, 180.0f, 270.0f, segments);
        RenderUtils.quarterCircle(x + w - r, y + r, r, 270.0f, 360.0f, segments);
        RenderUtils.quarterCircle(x + w - r, y + h - r, r, 0.0f, 90.0f, segments);
        RenderUtils.quarterCircle(x + r, y + h - r, r, 90.0f, 180.0f, segments);
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void rect(float x1, float y1, float x2, float y2) {
        float t;
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        Tessellator tess = Tessellator.getInstance();
        WorldRenderer wr = tess.getWorldRenderer();
        wr.begin(7, DefaultVertexFormats.POSITION);
        wr.pos(x1, y2, 0.0).endVertex();
        wr.pos(x2, y2, 0.0).endVertex();
        wr.pos(x2, y1, 0.0).endVertex();
        wr.pos(x1, y1, 0.0).endVertex();
        tess.draw();
    }

    private static void quarterCircle(float cx, float cy, float r, float startDeg, float endDeg, int segments) {
        double start = Math.toRadians(startDeg);
        double end = Math.toRadians(endDeg);
        double step = (end - start) / (double)segments;
        GL11.glBegin((int)6);
        GL11.glVertex2f((float)cx, (float)cy);
        int i = 0;
        while (i <= segments) {
            double ang = start + step * (double)i;
            float x = (float)((double)cx + Math.cos(ang) * (double)r);
            float y = (float)((double)cy + Math.sin(ang) * (double)r);
            GL11.glVertex2f((float)x, (float)y);
            ++i;
        }
        GL11.glEnd();
    }
}

