/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class DurationFormatter {
    private static final long MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private static final long HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final long DAY = TimeUnit.DAYS.toMillis(1L);
    private static SimpleDateFormat FRENCH_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    public static final ThreadLocal<DecimalFormat> REMAINING_SECONDS = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.#");
        }
    };
    public static final ThreadLocal<DecimalFormat> REMAINING_SECONDS_TRAILING = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.0");
        }
    };

    public static String getRemaining(long millis, boolean milliseconds) {
        return DurationFormatter.getRemaining(millis, milliseconds, true);
    }

    public static String getRemaining(long duration, boolean milliseconds, boolean trail) {
        if (milliseconds && duration < MINUTE) {
            return String.valueOf((trail ? REMAINING_SECONDS_TRAILING : REMAINING_SECONDS).get().format((double)duration * 0.001)) + 's';
        }
        if (duration >= DAY) {
            return DurationFormatUtils.formatDuration((long)duration, (String)"dd-HH:mm:ss");
        }
        return DurationFormatUtils.formatDuration((long)duration, (String)(String.valueOf(duration >= HOUR ? "HH:" : "") + "mm:ss"));
    }

    public static String getDurationWords(long duration) {
        return DurationFormatUtils.formatDuration((long)duration, (String)"H' heures 'm' minutes'");
    }

    public static String getDurationDate(long duration) {
        return FRENCH_DATE_FORMAT.format(new Date(duration));
    }

    public static String getCurrentDate() {
        return FRENCH_DATE_FORMAT.format(new Date());
    }
}

