/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.velunia.util.configs.ArmorHudConfig;
import fr.velunia.util.configs.CPSConfig;
import fr.velunia.util.configs.ClaimHudConfig;
import fr.velunia.util.configs.CoordinatesConfig;
import fr.velunia.util.configs.DirectionConfig;
import fr.velunia.util.configs.FPSConfig;
import fr.velunia.util.configs.KeystrokesConfig;
import fr.velunia.util.configs.PingConfig;
import fr.velunia.util.configs.PotionHudConfig;
import fr.velunia.util.configs.PseudoConfig;
import fr.velunia.util.configs.ToggleSprintConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_DIR = new File("config/velunia");
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "config.json");
    public KeystrokesConfig keystrokes = new KeystrokesConfig();
    public FPSConfig fps = new FPSConfig();
    public CPSConfig cps = new CPSConfig();
    public DirectionConfig direction = new DirectionConfig();
    public ArmorHudConfig armorhud = new ArmorHudConfig();
    public PotionHudConfig potion = new PotionHudConfig();
    public CoordinatesConfig coordinates = new CoordinatesConfig();
    public PseudoConfig pseudo = new PseudoConfig();
    public ToggleSprintConfig togglesprint = new ToggleSprintConfig();
    public PingConfig ping = new PingConfig();
    public ClaimHudConfig claim = new ClaimHudConfig();
    public static final String SKINS_PATH = "https://velunia-mc.fr/api/skin-api/skins/";
    public static final String CAPES_PATH = "https://velunia-mc.fr/api/skin-api/capes/";
    private static Config INSTANCE;

    public static Config getInstance() {
        if (INSTANCE == null) {
            INSTANCE = Config.load();
        }
        return INSTANCE;
    }

    private static Config load() {
        if (!CONFIG_FILE.exists()) {
            Config cfg = new Config();
            cfg.save();
            return cfg;
        }
        try {
            Throwable cfg = null;
            Object var1_4 = null;
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                return (Config)GSON.fromJson((Reader)reader, Config.class);
            }
            catch (Throwable throwable) {
                if (cfg == null) {
                    cfg = throwable;
                } else if (cfg != throwable) {
                    cfg.addSuppressed(throwable);
                }
                throw cfg;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Config();
        }
    }

    public void save() {
        try {
            if (!CONFIG_DIR.exists()) {
                CONFIG_DIR.mkdirs();
            }
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

