/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.util;

import fr.velunia.client.main.Vmain;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;

public class AntiXray
implements IResourceManagerReloadListener {
    private final Minecraft mc;
    private final List<String> textureToCheck = new ArrayList<String>();
    private final Map<String, String> modelToCheck = new HashMap<String, String>();
    private final String warning = "La triche est interdite sur Velunia ! Veuillez d\u00e9sactiver votre pack invisible pour continuer \u00e0 jouer !";
    private final double TRANSPARENCY_THRESHOLD = 0.01;

    public AntiXray(Minecraft mc) {
        this.mc = mc;
        this.init();
    }

    private void init() {
        this.textureToCheck.addAll(Arrays.asList("textures/blocks/stone.png", "textures/blocks/dirt.png", "textures/blocks/sand.png", "textures/blocks/grass_top.png", "textures/blocks/grass_side.png", "textures/blocks/crafting_table_top.png", "textures/blocks/crafting_table_side.png", "textures/blocks/crafting_table_front.png", "textures/blocks/gravel.png", "textures/blocks/obsidian.png"));
        this.modelToCheck.put("models/block/cube.json", "0a0b7d130d27b58817bad465cc275a54");
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        this.checkTextures(resourceManager);
        this.checkModels(resourceManager);
    }

    private void checkTextures(IResourceManager resourceManager) {
        for (String path : this.textureToCheck) {
            try {
                IResource res = resourceManager.getResource(new ResourceLocation(path));
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream stream = res.getInputStream();){
                    BufferedImage img = ImageIO.read(stream);
                    double transparentRatio = (double)this.countTransparentPixels(img) / (double)(img.getWidth() * img.getHeight());
                    if (transparentRatio > 0.01) {
                        this.showWarningAndBlock();
                        return;
                    }
                    Vmain.log("V\u00e9rification si utilisation d'un XRAY");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkModels(IResourceManager resourceManager) {
        for (Map.Entry<String, String> entry : this.modelToCheck.entrySet()) {
            try {
                IResource res = resourceManager.getResource(new ResourceLocation(entry.getKey()));
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(res.getInputStream()));){
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    String md5 = this.computeMD5(sb.toString());
                    if (md5 != null && md5.equalsIgnoreCase(entry.getValue())) continue;
                    this.showWarningAndBlock();
                    return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void showWarningAndBlock() {
        JOptionPane.showMessageDialog(new Frame(), "La triche est interdite sur Velunia ! Veuillez d\u00e9sactiver votre pack invisible pour continuer \u00e0 jouer !", "Velunia", 2);
        this.mc.shutdown();
        Vmain.log("Le joueur utilise un XRAY !");
    }

    private String computeMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(input.getBytes());
            StringBuilder sb = new StringBuilder();
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(String.format("%02x", b));
                ++n2;
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private int countTransparentPixels(BufferedImage image) {
        int count = 0;
        int width = image.getWidth();
        int height = image.getHeight();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int alpha = image.getRGB(x, y) >> 24 & 0xFF;
                if (alpha != 255) {
                    ++count;
                }
                ++y;
            }
            ++x;
        }
        return count;
    }
}

