/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.network.packet.read;

import fr.velunia.client.main.Vmain;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class PlayerInfoPacket {
    private static String grade;
    private static double money;
    private static int ping;
    private static String faction;
    private static boolean needsRefresh;
    private static String claim;

    static {
        needsRefresh = false;
    }

    public static void handle(ByteBuf buf) {
        try {
            grade = PlayerInfoPacket.readUTF(buf);
            money = buf.readDouble();
            faction = PlayerInfoPacket.readUTF(buf);
            ping = buf.readInt();
            claim = PlayerInfoPacket.readUTF(buf);
            Vmain.log("-----------------------------------------------------------");
            Vmain.log("[VPackets] PlayerInfo re\u00e7u :");
            Vmain.log(" - Grade: " + grade);
            Vmain.log(" - Argent: " + money);
            Vmain.log(" - Faction: " + faction);
            Vmain.log(" - Ping: " + ping);
            Vmain.log(" - Claim: " + claim);
            Vmain.log("-----------------------------------------------------------");
            needsRefresh = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String readUTF(ByteBuf buf) throws IOException {
        int length = buf.readUnsignedShort();
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        return new String(bytes, "UTF-8");
    }

    public static String getGrade() {
        return grade;
    }

    public static double getMoney() {
        return money;
    }

    public static String getFaction() {
        return faction;
    }

    public static int getPing() {
        return ping;
    }

    public static String getClaim() {
        return claim;
    }

    public static boolean isNeedsRefresh() {
        return needsRefresh;
    }

    public static void resetNeedsRefresh() {
        needsRefresh = false;
    }
}

