/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.mod.wiki;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class WikiCraft
extends GuiContainer {
    private static final int GUI_WIDTH = 195;
    private static final int GUI_HEIGHT = 190;
    private static final ResourceLocation tabCraft = new ResourceLocation("textures/gui/container/crafts.png");
    private static final ResourceLocation scrollTexture = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final Set<IRecipe> allRecipes = new LinkedHashSet<IRecipe>();
    private GuiTextField searchField;
    private float scroll = 0.0f;
    private List<ItemStack> displayedItems = new ArrayList<ItemStack>();
    private ItemStack selectedRecipe;
    private final ContainerCrafts container = (ContainerCrafts)this.inventorySlots;

    public WikiCraft(EntityPlayer player) {
        super(new ContainerCrafts());
        if (allRecipes.isEmpty()) {
            for (IRecipe recipe : CraftingManager.getInstance().getRecipeList()) {
                if (recipe.getRecipeOutput() == null) continue;
                allRecipes.add(recipe);
            }
        }
        this.displayedItems.addAll(this.container.displayedItems);
        this.sortItemsByID(this.displayedItems);
    }

    private void sortItemsByID(List<ItemStack> items) {
        items.sort(Comparator.comparingInt(stack -> Item.getIdFromItem(stack.getItem())));
    }

    @Override
    public void initGui() {
        super.initGui();
        this.searchField = new GuiTextField(0, this.fontRendererObj, this.guiLeft + 82, this.guiTop + 6, 89, this.fontRendererObj.FONT_HEIGHT);
        this.searchField.setMaxStringLength(50);
        this.searchField.setEnableBackgroundDrawing(false);
        this.searchField.setVisible(true);
        this.searchField.setFocused(false);
        this.updateDisplayedItems("");
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (this.searchField.textboxKeyTyped(typedChar, keyCode)) {
            this.updateDisplayedItems(this.searchField.getText());
        } else {
            super.keyTyped(typedChar, keyCode);
        }
    }

    private void updateDisplayedItems(String filter) {
        this.displayedItems.clear();
        String lower = filter.toLowerCase();
        for (IRecipe recipe : allRecipes) {
            ItemStack output = recipe.getRecipeOutput();
            if (output == null || !output.getDisplayName().toLowerCase().contains(lower)) continue;
            this.displayedItems.add(output);
        }
        this.sortItemsByID(this.displayedItems);
        this.scroll = 0.0f;
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        int dWheel = Mouse.getEventDWheel();
        if (dWheel != 0) {
            int rows = this.displayedItems.size() / 9 - 5 + 1;
            if (dWheel > 0) {
                dWheel = 1;
            } else if (dWheel < 0) {
                dWheel = -1;
            }
            this.scroll -= (float)dWheel / (float)rows;
            if (this.scroll < 0.0f) {
                this.scroll = 0.0f;
            }
            if (this.scroll > 1.0f) {
                this.scroll = 1.0f;
            }
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        int craftY;
        int craftX;
        ItemStack stack;
        int y;
        int x;
        int col;
        int row;
        GlStateManager.disableLighting();
        GlStateManager.disableBlend();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        Minecraft.getMinecraft().getTextureManager().bindTexture(tabCraft);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, 195, 190);
        this.searchField.drawTextBox();
        this.drawCenteredString(this.fontRendererObj, "Menu des Crafts", this.width / 2, this.guiTop - 10, 0xFFFFFF);
        int startX = this.guiLeft + 10;
        int startY = this.guiTop + 20;
        int slotSize = 18;
        int itemsPerRow = 9;
        int visibleRows = 5;
        int rowOffset = (int)(this.scroll * (float)(this.displayedItems.size() / itemsPerRow - visibleRows + 1));
        GlStateManager.enableLighting();
        RenderHelper.enableGUIStandardItemLighting();
        int i = 0;
        while (i < this.displayedItems.size()) {
            row = i / itemsPerRow - rowOffset;
            col = i % itemsPerRow;
            if (row >= 0 && row < visibleRows) {
                x = startX + col * slotSize;
                y = startY + row * slotSize - 2;
                stack = this.displayedItems.get(i);
                this.itemRender.renderItemAndEffectIntoGUI(stack, x, y);
                if (mouseX >= x && mouseX < x + slotSize && mouseY >= y && mouseY < y + slotSize && Mouse.isButtonDown((int)0) && this.selectedRecipe != stack) {
                    this.selectedRecipe = stack;
                    this.container.setRecipe(stack);
                }
            }
            ++i;
        }
        GlStateManager.disableLighting();
        if (this.displayedItems.size() > visibleRows * itemsPerRow) {
            int scrollHeight = 90;
            int barX = startX + itemsPerRow * slotSize + 2;
            int barY = startY - 3;
            int barWidth = 14;
            int handleHeight = Math.max(10, scrollHeight * visibleRows * itemsPerRow / this.displayedItems.size());
            int handleY = barY + (int)((float)(scrollHeight - handleHeight) * this.scroll);
            WikiCraft.drawRect(barX, barY, barX + barWidth, barY + scrollHeight, -7829368);
            WikiCraft.drawRect(barX, handleY, barX + barWidth, handleY + handleHeight, -3355444);
        }
        if (this.selectedRecipe != null) {
            craftX = this.guiLeft + 124;
            craftY = this.guiTop + 138;
            this.container.renderRecipe(craftX, craftY);
        }
        i = 0;
        while (i < this.displayedItems.size()) {
            row = i / itemsPerRow - rowOffset;
            col = i % itemsPerRow;
            if (row >= 0 && row < visibleRows) {
                x = startX + col * slotSize;
                y = startY + row * slotSize - 2;
                stack = this.displayedItems.get(i);
                if (mouseX >= x && mouseX < x + slotSize && mouseY >= y && mouseY < y + slotSize) {
                    this.renderToolTip(stack, mouseX, mouseY);
                }
            }
            ++i;
        }
        if (this.selectedRecipe != null) {
            craftX = this.guiLeft + 124;
            craftY = this.guiTop + 138;
            if (mouseX >= craftX && mouseX < craftX + 16 && mouseY >= craftY && mouseY < craftY + 16) {
                this.renderToolTip(this.selectedRecipe, mouseX, mouseY);
            }
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
    }

    public static class ContainerCrafts
    extends Container {
        public List<ItemStack> displayedItems = new ArrayList<ItemStack>();
        private IRecipe currentRecipe;

        public ContainerCrafts() {
            for (IRecipe r : CraftingManager.getInstance().getRecipeList()) {
                if (r.getRecipeOutput() == null) continue;
                this.displayedItems.add(r.getRecipeOutput());
            }
        }

        public void setRecipe(ItemStack stack) {
            for (IRecipe recipe : CraftingManager.getInstance().getRecipeList()) {
                if (recipe.getRecipeOutput() == null || !recipe.getRecipeOutput().isItemEqual(stack)) continue;
                this.currentRecipe = recipe;
                break;
            }
        }

        public void renderRecipe(int x, int y) {
            block7: {
                int startY;
                int startX;
                int slotSize;
                Minecraft mc;
                block6: {
                    if (this.currentRecipe == null) {
                        return;
                    }
                    mc = Minecraft.getMinecraft();
                    mc.getRenderItem().renderItemAndEffectIntoGUI(this.currentRecipe.getRecipeOutput(), x, y);
                    slotSize = 18;
                    startX = x - slotSize * 5;
                    startY = y - slotSize;
                    if (!(this.currentRecipe instanceof ShapedRecipes)) break block6;
                    ShapedRecipes shaped = (ShapedRecipes)this.currentRecipe;
                    int row = 0;
                    while (row < shaped.recipeHeight) {
                        int col = 0;
                        while (col < shaped.recipeWidth) {
                            int index = row * shaped.recipeWidth + col;
                            ItemStack stack = shaped.recipeItems[index];
                            if (stack != null) {
                                mc.getRenderItem().renderItemAndEffectIntoGUI(stack, startX + col * slotSize, startY + row * slotSize);
                            }
                            ++col;
                        }
                        ++row;
                    }
                    break block7;
                }
                if (!(this.currentRecipe instanceof ShapelessRecipes)) break block7;
                ShapelessRecipes shapeless = (ShapelessRecipes)this.currentRecipe;
                List<ItemStack> items = shapeless.recipeItems;
                int i = 0;
                while (i < items.size() && i < 9) {
                    ItemStack stack = items.get(i);
                    if (stack != null) {
                        mc.getRenderItem().renderItemAndEffectIntoGUI(stack, startX + i % 3 * slotSize, startY + i / 3 * slotSize);
                    }
                    ++i;
                }
            }
        }

        @Override
        public boolean canInteractWith(EntityPlayer player) {
            return true;
        }
    }
}

