/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.mod.ping;

import fr.velunia.client.mod.ping.PingRenderer;
import fr.velunia.network.packet.read.PlayerInfoPacket;
import fr.velunia.util.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.network.NetworkPlayerInfo;

public class Ping {
    private final Minecraft mc = Minecraft.getMinecraft();
    private final int xOffset;
    private final int yOffset;
    private int color = 255;
    private double textBrightness = 1.0;

    public Ping(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void renderHud(int x, int y, int textColor) {
        Config cfg = Config.getInstance();
        if (!this.mc.gameSettings.showDebugInfo) {
            FontRenderer fr = this.mc.fontRendererObj;
            NetworkPlayerInfo networkPlayerInfo = this.mc.getNetHandler().getPlayerInfo(this.mc.thePlayer.getUniqueID());
            if (networkPlayerInfo != null) {
                String sPing;
                int ping = networkPlayerInfo.getResponseTime();
                boolean k = false;
                if ((long)ping > 0L) {
                    if ((long)ping < 0L) {
                        int l = 5;
                    } else if ((long)ping < 150L) {
                        boolean l = false;
                    } else if ((long)ping < 300L) {
                        boolean l = true;
                    } else if ((long)ping < 600L) {
                        int l = 2;
                    } else if ((long)ping < 1000L) {
                        int l = 3;
                    } else {
                        int l = 4;
                    }
                    sPing = (long)ping < 0L ? "(no connection)" : String.valueOf(ping) + " ms";
                } else {
                    k = true;
                    int l = (int)(Minecraft.getSystemTime() / 100L + 2L & 7L);
                    if (l > 4) {
                        l = 8 - l;
                    }
                    sPing = "Pinging...";
                }
                int textWidth = fr.getStringWidth(sPing);
                int textHeight = fr.FONT_HEIGHT;
                int color = PingRenderer.getColor(textColor, y + this.yOffset + 8 + x + this.xOffset + 8);
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color & 0xFF;
                int finalColor = -16777216 + ((int)((double)red * this.textBrightness) << 16) + ((int)((double)green * this.textBrightness) << 8) + (int)((double)blue * this.textBrightness);
                int left = x + this.xOffset - 2;
                int right = x + this.xOffset + textWidth + 2;
                int top = y + this.yOffset - 2;
                int bottom = y + this.yOffset + textHeight + 2;
                if (cfg.ping.hasBackground()) {
                    Gui.drawRect(left, top, right, bottom, -1341124592);
                }
                Gui.drawRect(left, top, right, top + 1, finalColor);
                Gui.drawRect(left, bottom - 1, right, bottom, finalColor);
                Gui.drawRect(left, top, left + 1, bottom, finalColor);
                Gui.drawRect(right - 1, top, right, bottom, finalColor);
                fr.drawStringWithShadow(sPing, x + this.xOffset, y + this.yOffset, finalColor);
            }
        }
    }

    public int getWidth() {
        FontRenderer fr = this.mc.fontRendererObj;
        String sPing = null;
        NetworkPlayerInfo networkPlayerInfo = this.mc.getNetHandler().getPlayerInfo(this.mc.thePlayer.getUniqueID());
        if (networkPlayerInfo != null) {
            int ping = networkPlayerInfo.getResponseTime();
            boolean k = false;
            if ((long)ping > 0L) {
                if ((long)ping < 0L) {
                    int l = 5;
                } else if ((long)ping < 150L) {
                    boolean l = false;
                } else if ((long)ping < 300L) {
                    boolean l = true;
                } else if ((long)ping < 600L) {
                    int l = 2;
                } else if ((long)ping < 1000L) {
                    int l = 3;
                } else {
                    int l = 4;
                }
                sPing = (long)ping < 0L ? "(no connection)" : String.valueOf(ping) + " ms";
            } else {
                k = true;
                int l = (int)(Minecraft.getSystemTime() / 100L + 2L & 7L);
                if (l > 4) {
                    l = 8 - l;
                }
                sPing = "Pinging...";
            }
        }
        String displayText = String.valueOf(PlayerInfoPacket.getPing()) + " ms";
        int textWidth = fr.getStringWidth(sPing);
        return textWidth + 4;
    }

    public int getHeight() {
        FontRenderer fr = this.mc.fontRendererObj;
        int lineHeight = fr.FONT_HEIGHT + 4;
        return lineHeight;
    }
}

