/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.mod.fps;

import fr.velunia.client.mod.fps.Fps;
import fr.velunia.client.mod.fps.GuiScreenFps;
import fr.velunia.util.Config;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;

public class FpsRenderer {
    public static final int[] COLORS = new int[]{0xFFFFFF, 0xFF0000, 652801, 255, 0xFFFF00, 0xAA00AA};
    private final Minecraft mc = Minecraft.getMinecraft();
    private final Fps[] fps = new Fps[1];

    public FpsRenderer() {
        this.fps[0] = new Fps(26, 2);
    }

    public static void RenderFPS() throws IOException {
        FpsRenderer k = new FpsRenderer();
        if (Minecraft.getMinecraft().currentScreen != null && Minecraft.getMinecraft().currentScreen instanceof GuiScreenFps) {
            Minecraft.getMinecraft().currentScreen.handleInput();
        }
    }

    public void renderFps() {
        Config cfg = Config.getInstance();
        if (cfg.fps.isEnabled()) {
            int x = cfg.fps.getX();
            int y = cfg.fps.getY();
            ScaledResolution res = new ScaledResolution(Minecraft.getMinecraft());
            int width = 52;
            int height = this.getHudHeight();
            if (x < -26) {
                cfg.fps.setX(-26);
                x = cfg.fps.getX();
            } else if (x > res.getScaledWidth() - width) {
                cfg.fps.setX(res.getScaledWidth() - width);
                x = cfg.fps.getX();
            }
            if (y < 0) {
                cfg.fps.setY(0);
                y = cfg.fps.getY();
            } else if (y > res.getScaledHeight() - height) {
                cfg.fps.setY(res.getScaledHeight() - height);
                y = cfg.fps.getY();
            }
            this.drawFps(x, y, cfg.fps.getTextColor());
        }
    }

    private void drawFps(int x, int y, int textColor) {
        Fps[] fpsArray = this.fps;
        int n = this.fps.length;
        int n2 = 0;
        while (n2 < n) {
            Fps key = fpsArray[n2];
            key.renderHud(x, y, textColor);
            ++n2;
        }
    }

    public static int getColor(int index, int i) {
        return index == 6 ? Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 0.8f, 0.8f) : (index == 7 ? Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f + (float)i / 1000.0f * 4.0f, 0.8f, 0.8f) : COLORS[index]);
    }

    private int getHudHeight() {
        return this.fps.length * 12;
    }
}

