/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.mod.armorhud;

import fr.velunia.client.mod.armorhud.Hud;
import fr.velunia.util.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;

public class HudRenderer {
    private final Minecraft mc = Minecraft.getMinecraft();
    private final Hud[] armorhud = new Hud[1];

    public HudRenderer() {
        this.armorhud[0] = new Hud(0, 0);
    }

    public void renderHud() {
        Config cfg = Config.getInstance();
        if (cfg.armorhud.isEnabled()) {
            int x = cfg.armorhud.getX();
            int y = cfg.armorhud.getY();
            ScaledResolution res = new ScaledResolution(this.mc);
            int hudHeight = this.getHudHeight();
            x = Math.max(0, Math.min(res.getScaledWidth() - this.getHudWidth(), x));
            y = Math.max(0, Math.min(res.getScaledHeight() - hudHeight, y));
            cfg.armorhud.setX(x);
            cfg.armorhud.setY(y);
            this.drawHud(x, y);
        }
    }

    private void drawHud(int x, int y) {
        Hud[] hudArray = this.armorhud;
        int n = this.armorhud.length;
        int n2 = 0;
        while (n2 < n) {
            Hud hud = hudArray[n2];
            hud.renderHud(x, y);
            ++n2;
        }
    }

    public int getHudHeight() {
        return this.armorhud[0].getHeight();
    }

    public int getHudWidth() {
        return this.armorhud[0].getWidth();
    }

    public int getXOffset() {
        return this.armorhud[0].getXOffset();
    }

    public int getYOffset() {
        return this.armorhud[0].getYOffset();
    }
}

