/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.mod.armorhud;

import fr.velunia.util.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import org.lwjgl.opengl.GL11;

public class Hud {
    private final Minecraft mc = Minecraft.getMinecraft();
    private final int xOffset;
    private final int yOffset;

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public Hud(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void renderHud(int x, int y) {
        Config cfg = Config.getInstance();
        if (!this.mc.gameSettings.showDebugInfo) {
            ItemStack helmet = this.mc.thePlayer.inventory.armorItemInSlot(3);
            ItemStack chestplate = this.mc.thePlayer.inventory.armorItemInSlot(2);
            ItemStack leggings = this.mc.thePlayer.inventory.armorItemInSlot(1);
            ItemStack boots = this.mc.thePlayer.inventory.armorItemInSlot(0);
            ItemStack hand = this.mc.thePlayer.inventory.getCurrentItem();
            int currentY = y;
            currentY = this.drawArmorPiece(helmet, x, currentY, cfg);
            currentY = this.drawArmorPiece(chestplate, x, currentY, cfg);
            currentY = this.drawArmorPiece(leggings, x, currentY, cfg);
            currentY = this.drawArmorPiece(boots, x, currentY, cfg);
            currentY = this.drawArmorPiece(hand, x, currentY, cfg, true);
        }
    }

    private int drawArmorPiece(ItemStack item, int x, int y, Config cfg) {
        return this.drawArmorPiece(item, x, y, cfg, false);
    }

    private int drawArmorPiece(ItemStack item, int x, int y, Config cfg, boolean isHand) {
        int color;
        String displayText;
        if (item == null) {
            return y;
        }
        if (!(!isHand || item.getItem() instanceof ItemSword || item.getItem() instanceof ItemBow || item.getItem() instanceof ItemTool || item.getItem() instanceof ItemFlintAndSteel || item.getItem() instanceof ItemShears || item.getItem() instanceof ItemFishingRod)) {
            return y;
        }
        int maxDamage = item.getMaxDamage();
        int remaining = maxDamage - item.getItemDamage();
        int percent = (int)((float)remaining / (float)maxDamage * 100.0f);
        if (cfg.armorhud.isPourcentage()) {
            displayText = String.valueOf(percent) + "%";
            color = this.getColor(percent);
        } else {
            displayText = String.valueOf(remaining);
            color = 0xFFFFFF;
        }
        this.mc.fontRendererObj.drawString(displayText, x + this.xOffset + 21, y, color);
        this.mc.getRenderItem().renderItemAndEffectIntoGUI(item, x + this.xOffset, y - 5);
        GL11.glDisable((int)2896);
        return y + 17;
    }

    private int getColor(int percent) {
        if (percent > 85) {
            return -16733696;
        }
        if (percent > 70) {
            return -16711936;
        }
        if (percent > 55) {
            return -256;
        }
        if (percent > 40) {
            return -22016;
        }
        if (percent > 25) {
            return -65536;
        }
        return -5636096;
    }

    public int getHeight() {
        ItemStack[] items;
        int height = 0;
        ItemStack[] itemStackArray = items = new ItemStack[]{this.mc.thePlayer.inventory.armorItemInSlot(3), this.mc.thePlayer.inventory.armorItemInSlot(2), this.mc.thePlayer.inventory.armorItemInSlot(1), this.mc.thePlayer.inventory.armorItemInSlot(0), this.mc.thePlayer.inventory.getCurrentItem()};
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item != null) {
                height += 17;
            }
            ++n2;
        }
        return height;
    }

    public int getWidth() {
        return 50;
    }
}

