/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.gui.button;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

public class GuiButtonToggle
extends GuiButton {
    private boolean enabled;
    private final String label;

    public GuiButtonToggle(int buttonId, int x, int y, int widthIn, int heightIn, String label, boolean initialState) {
        super(buttonId, x, y, widthIn, heightIn, "");
        this.label = label;
        this.enabled = initialState;
        this.updateDisplayString();
    }

    public void toggle() {
        this.enabled = !this.enabled;
        this.updateDisplayString();
    }

    private void updateDisplayString() {
        this.displayString = String.valueOf(this.label) + " : " + (this.enabled ? "\u00a7aOui" : "\u00a7cNon");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            boolean hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
            int bg = hovered ? -1717986919 : -1877995504;
            GuiButtonToggle.drawRect(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, bg);
            mc.fontRendererObj.drawStringWithShadow(this.displayString, this.xPosition + 6, this.yPosition + (this.height - 8) / 2, 0xFFFFFF);
        }
    }
}

