/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.gui.button;

import fr.velunia.client.main.Vmain;
import fr.velunia.util.Colors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiButtonItem
extends GuiButton {
    private ResourceLocation ButtonTexture = new ResourceLocation("textures/gui/widgets.png");
    private RenderItem itemRenderer = Vmain.MINECRAFT.getMinecraft().getRenderItem();
    private ItemStack itemToDisplay;
    private int itemPosX;
    private int itemPosY;
    public final int coord1;
    public final int coord2;
    public final int longeur;
    public final int longeur2;
    public final String texte;
    private int step;

    public GuiButtonItem(int par1, int par2, int par3, int par4, int par5, String text, ItemStack itemStack, int itemPosX, int itemPosY) {
        super(par1, par2, par3, par4, par5, text);
        this.itemToDisplay = itemStack;
        this.itemPosX = itemPosX;
        this.itemPosY = itemPosY;
        this.coord1 = par2;
        this.coord2 = par3;
        this.longeur = par4;
        this.longeur2 = par5;
        this.texte = text;
        this.step = 0;
    }

    @Override
    public void drawButton(Minecraft mc, int par1, int par2) {
        int xPosition = this.xPosition;
        int yPosition = this.yPosition;
        int width = this.width;
        int height = this.height;
        boolean hovered = par1 >= xPosition && par2 >= yPosition && par1 < xPosition + width && par2 < yPosition + height;
        FontRenderer var4 = mc.fontRendererObj;
        mc.getTextureManager().bindTexture(this.ButtonTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.hovered = par1 >= this.xPosition && par2 >= this.yPosition && par1 < this.xPosition + this.width && par2 < this.yPosition + this.height;
        this.mouseDragged(mc, par1, par2);
        int var5 = this.getHoverState(this.hovered);
        if (!hovered) {
            GuiButtonItem.drawRect(this.coord1 - this.step, this.coord2, this.coord1 + this.longeur + this.step, this.coord2 + this.longeur2, Colors.getShopItemFont());
        } else {
            GuiButtonItem.drawRect(this.coord1 - this.step, this.coord2, this.coord1 + this.longeur + this.step, this.coord2 + this.longeur2, Colors.getShopItemFont());
            this.drawRectangle(this.coord1 - this.step, this.coord2, this.coord1 + this.longeur + this.step, this.coord2 + this.longeur2, Colors.getRed().getRGB());
        }
        GlStateManager.enableLighting();
        GlStateManager.enableRescaleNormal();
        this.itemRenderer.zLevel = 100.0f;
        this.itemRenderer.renderItemIntoGUI(this.itemToDisplay, xPosition + width / 2 - 8, yPosition + 2);
        GlStateManager.disableLighting();
    }

    @Override
    public void drawRectangle(int posX, int posY, int maxPosX, int maxPosY, int color) {
        this.drawHorizontalLine(posX, maxPosX, posY, color);
        this.drawHorizontalLine(posX, maxPosX, maxPosY, color);
        this.drawVerticalLine(posX, posY, maxPosY, color);
        this.drawVerticalLine(maxPosX, posY, maxPosY, color);
    }
}

