/*
 * Decompiled with CFR 0.152.
 */
package fr.zirconia.haysiou;

import fr.theshark34.openlauncherlib.external.ClasspathConstructor;
import fr.theshark34.openlauncherlib.external.ExternalLaunchProfile;
import fr.theshark34.openlauncherlib.external.ExternalLauncher;
import fr.theshark34.openlauncherlib.minecraft.util.GameDirGenerator;
import fr.theshark34.openlauncherlib.util.CrashReporter;
import fr.theshark34.openlauncherlib.util.ProcessLogManager;
import fr.theshark34.openlauncherlib.util.SplashScreen;
import fr.theshark34.openlauncherlib.util.explorer.Explorer;
import fr.theshark34.supdate.SUpdate;
import fr.theshark34.supdate.application.integrated.FileDeleter;
import fr.theshark34.swinger.Swinger;
import java.io.File;

public class Bootstrap {
    private static SplashScreen screen;
    private static File folder;
    private static CrashReporter reporter;

    static {
        folder = new File(GameDirGenerator.createGameDir("velunia"), "launcher");
        reporter = new CrashReporter("velunia", new File(folder, "crashes"));
    }

    public static void main(String[] args) {
        Swinger.setResourcePath("/res");
        Bootstrap.displaySplash();
        try {
            Bootstrap.update();
        }
        catch (Exception e) {
            reporter.catchError(e, "Impossible de mettre \u00e0 jour le Launcher !");
        }
        screen.setVisible(false);
        try {
            Bootstrap.launch();
        }
        catch (Exception e) {
            reporter.catchError(e, "Impossible de lancer le launcher !");
        }
    }

    private static void displaySplash() {
        screen = new SplashScreen("test", Swinger.getResource("logo.png"));
        screen.setLayout(null);
        screen.setVisible(true);
        screen.setBackground(Swinger.TRANSPARENT);
    }

    private static void update() throws Exception {
        SUpdate su = new SUpdate("https://launcher.velunia-mc.fr/bootstrap/", folder);
        su.getServerRequester().setRewriteEnabled(true);
        su.addApplication(new FileDeleter());
        su.start();
    }

    private static void launch() throws Exception {
        ClasspathConstructor constructor = new ClasspathConstructor();
        constructor.add(Explorer.dir(folder).sub("libs").files());
        constructor.add(Explorer.dir(folder).get("launcher.jar"));
        ExternalLaunchProfile profile = new ExternalLaunchProfile("fr.haysiou.launcher.template.LauncherMain", constructor.make());
        profile.setRedirectErrorStream(true);
        ExternalLauncher launcher = new ExternalLauncher(profile);
        Process p = launcher.launch();
        ProcessLogManager manager = new ProcessLogManager(p.getInputStream());
        manager.start();
        p.waitFor();
        System.exit(0);
    }
}

