/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.supdate;

import fr.theshark34.supdate.ServerRequester;
import fr.theshark34.supdate.Updater;
import fr.theshark34.supdate.application.Application;
import fr.theshark34.supdate.application.ApplicationManager;
import fr.theshark34.supdate.check.CheckMethod;
import fr.theshark34.supdate.exception.BadServerResponseException;
import fr.theshark34.supdate.exception.BadServerVersionException;
import fr.theshark34.supdate.exception.ServerDisabledException;
import fr.theshark34.supdate.exception.ServerMissingSomethingException;
import fr.theshark34.supdate.files.FileManager;
import java.io.File;
import java.io.IOException;
import net.wytrem.wylog.BasicLogger;
import net.wytrem.wylog.LoggerFactory;

public class SUpdate {
    public static final BasicLogger logger = LoggerFactory.getLogger("S-Update");
    public static final String VERSION = "S-Update Client version 3.1.0-BETA by TheShark34";
    public static final String SERV_MIN_VERSION = "3.1.0-BETA";
    private String serverUrl;
    private File outputFolder;
    private CheckMethod checkMethod = Updater.DEFAULT_CHECK_METHOD;
    private ApplicationManager applicationManager = new ApplicationManager();
    private FileManager fileManager = new FileManager(this);
    private ServerRequester serverRequester = new ServerRequester(this);
    private Updater updater;

    public SUpdate(String serverUrl, File outputFolder) {
        this.serverUrl = serverUrl;
        this.outputFolder = outputFolder;
    }

    public void start() throws BadServerResponseException, ServerDisabledException, BadServerVersionException, ServerMissingSomethingException, IOException {
        this.updater = new Updater(this);
        this.updater.start();
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setCheckMethod(CheckMethod checkMethod) {
        this.checkMethod = checkMethod;
    }

    public CheckMethod getCheckMethod() {
        return this.checkMethod;
    }

    public void addApplication(Application application) {
        this.applicationManager.addApplication(this, application);
    }

    public ApplicationManager getApplicationManager() {
        return this.applicationManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public ServerRequester getServerRequester() {
        return this.serverRequester;
    }

    public Updater getUpdater() {
        return this.updater;
    }
}

